/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection;

import java.io.File;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.util.Callback;

public class MusicCollectionCellFactory
implements Callback<TreeView<File>, TreeCell<File>> {
    private static final String CURRENTLY_PLAYED_FILE_ROW = "currentlyPlayedRow";
    private ObjectProperty<List<TreeItem<File>>> currentlyPlayedTreeItemsProperty;

    public void setCurrentlyPlayedTreeItems(ObjectProperty<List<TreeItem<File>>> currentlyPlayedTreeItems) {
        this.currentlyPlayedTreeItemsProperty = currentlyPlayedTreeItems;
    }

    public TreeCell<File> call(TreeView<File> treeView) {
        return new TextFieldTreeCellImpl();
    }

    public class TextFieldTreeCellImpl
    extends TreeCell<File> {
        private ChangeListener<List<TreeItem<File>>> listChangeListener = (observable, oldValue, newValue) -> this.setCellStyle();

        public TextFieldTreeCellImpl() {
            MusicCollectionCellFactory.this.currentlyPlayedTreeItemsProperty.addListener((ChangeListener)new WeakChangeListener(this.listChangeListener));
        }

        protected void updateItem(File file, boolean empty) {
            super.updateItem((Object)file, empty);
            if (!empty && file != null) {
                this.setText(file.getName());
                this.setGraphic(this.getTreeItem().getGraphic());
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
            this.setCellStyle();
        }

        private void setCellStyle() {
            this.getStyleClass().remove((Object)MusicCollectionCellFactory.CURRENTLY_PLAYED_FILE_ROW);
            if (!this.isEmpty() && this.isCurrentlyPlayed()) {
                this.getStyleClass().add((Object)MusicCollectionCellFactory.CURRENTLY_PLAYED_FILE_ROW);
            }
        }

        private boolean isCurrentlyPlayed() {
            return MusicCollectionCellFactory.this.currentlyPlayedTreeItemsProperty.get() != null ? ((List)MusicCollectionCellFactory.this.currentlyPlayedTreeItemsProperty.get()).stream().filter(treeItem -> ((File)treeItem.getValue()).equals(this.getItem())).findFirst().isPresent() : false;
        }
    }
}

